/*
 * Decompiled with CFR 0.152.
 */
package ch.unige.ntic.imageries;

import ij.io.GifEncoder;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.apache.log4j.Category;

public class ImagesTreatment {
    static final Category BUFFERED_IMAGE;
    static final Category CAT;
    static final Category CHANGE_SIZE;
    static final Category OPEN_IMAGE;
    static final Category RESIZER;
    static final Category SAVE_AS_GIF;
    static final Category SAVE_IMAGE;
    static /* synthetic */ Class class$ch$unige$ntic$imageries$ImagesTreatment;
    static final String className;
    private BufferedImage image;
    private Vector imagesList;
    private double ratio;
    private String type;

    static {
        className = (class$ch$unige$ntic$imageries$ImagesTreatment == null ? (class$ch$unige$ntic$imageries$ImagesTreatment = ImagesTreatment.class$("ch.unige.ntic.imageries.ImagesTreatment")) : class$ch$unige$ntic$imageries$ImagesTreatment).getName();
        CAT = Category.getInstance(className);
        CHANGE_SIZE = Category.getInstance(className + ".CHANGE_SIZE");
        OPEN_IMAGE = Category.getInstance(className + ".OPEN_IMAGE");
        SAVE_AS_GIF = Category.getInstance(className + ".SAVE_AS_GIF");
        SAVE_IMAGE = Category.getInstance(className + ".SAVE_IMAGE");
        BUFFERED_IMAGE = Category.getInstance(className + ".BUFFERED_IMAGE");
        RESIZER = Category.getInstance(className + ".RESIZER");
    }

    public ImagesTreatment(Vector imagesListInput) {
        this.setImagesList(imagesListInput);
        CAT.info("Entered the ImageTreatment constructor.");
    }

    public void changeSizes() {
        CHANGE_SIZE.info("Entered the changeSize method");
        Vector imagesList = this.getImagesList();
        int sizelist = imagesList.size();
        int i = 0;
        while (i < sizelist) {
            int width = (Integer)imagesList.elementAt(i++);
            int height = (Integer)imagesList.elementAt(i++);
            String name = (String)imagesList.elementAt(i);
            this.openImage(name);
            if (this.getImage() != null) {
                this.resizer(width, height);
                this.defineTypeOfImage(name);
                this.saveImage(name);
            } else {
                CHANGE_SIZE.error("The image is null, path = " + name);
            }
            ++i;
        }
        CHANGE_SIZE.info("out of the changeSize method");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static BufferedImage copy(BufferedImage source, BufferedImage target) {
        Graphics2D g2 = target.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        double scalex = (double)target.getWidth() / (double)source.getWidth();
        double scaley = (double)target.getHeight() / (double)source.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scalex, scaley);
        g2.drawRenderedImage(source, xform);
        g2.dispose();
        return target;
    }

    public void defineTypeOfImage(String path) {
        this.setType(path.substring(path.length() - 3));
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Vector getImagesList() {
        return this.imagesList;
    }

    public static BufferedImage getScaledInstance(BufferedImage image, int width, int height, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = ImagesTreatment.getDefaultConfiguration();
        }
        int transparency = image.getColorModel().getTransparency();
        return gc.createCompatibleImage(width, height, transparency);
    }

    public String getType() {
        return this.type;
    }

    public void openImage(String path) {
        File imageFile = new File(path);
        try {
            BufferedImage bImage = ImageIO.read(imageFile);
            this.setImage(bImage);
        }
        catch (IOException ex) {
            OPEN_IMAGE.error("OpenImage not open", ex);
        }
    }

    private void resizer(int width, int height) {
        RESIZER.info("entered in the resizer method");
        BufferedImage image = this.getImage();
        if (width < image.getWidth() - 2) {
            RESIZER.info("The picture is smaller than the original");
            this.setImage(this.toBufferedImage(image.getScaledInstance(width, height, 16), image.getColorModel()));
        } else if (width > image.getWidth() + 2) {
            RESIZER.info("The picture is bigger than the original");
            GraphicsConfiguration gc = ImagesTreatment.getDefaultConfiguration();
            this.setImage(ImagesTreatment.copy(image, ImagesTreatment.getScaledInstance(image, width, height, gc)));
        }
        RESIZER.info("out of resizer method");
    }

    public void saveAsGif(BufferedImage gifImage, String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e2) {
            SAVE_AS_GIF.error("gif file not created", e2);
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            GifEncoder encoder = new GifEncoder(gifImage);
            encoder.write(out);
            out.flush();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e2) {
            SAVE_AS_GIF.error("gif file not found", e2);
        }
        catch (IOException ioe) {
            SAVE_AS_GIF.error("IOException", ioe);
        }
    }

    public void saveImage(String path) {
        String type = this.getType();
        if (type.compareTo("png") == 0) {
            try {
                ImageIO.write((RenderedImage)this.getImage(), "png", new File(path));
            }
            catch (IOException ex) {
                SAVE_IMAGE.error("The png image not saved", ex);
            }
        } else if (type.compareTo("jpg") == 0) {
            try {
                ImageIO.write((RenderedImage)this.getImage(), "jpg", new File(path));
            }
            catch (IOException ex) {
                SAVE_IMAGE.error("The jpg image not saved", ex);
            }
        } else if (type.compareTo("gif") == 0) {
            this.saveAsGif(this.getImage(), path);
        }
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setImagesList(Vector imagesList) {
        this.imagesList = imagesList;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BufferedImage toBufferedImage(Image image, ColorModel cm) {
        BufferedImage bi;
        BUFFERED_IMAGE.info("Enter in the BufferedImage");
        if (image instanceof BufferedImage && cm.equals((bi = (BufferedImage)image).getColorModel())) {
            return bi;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        boolean alphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
        BufferedImage result = new BufferedImage(cm, raster, alphaPremultiplied, null);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        BUFFERED_IMAGE.info("return result");
        return result;
    }
}

